<?php
function mytheme_mailchimp_list_ids($apiKey) {
	
	$dataCenter = substr($apiKey,strpos($apiKey,'-')+1);
	$url = 'https://' . $dataCenter . '.api.mailchimp.com/3.0/lists/';
	
	$ch = curl_init($url);
	curl_setopt($ch, CURLOPT_USERPWD, 'user:' . $apiKey);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_TIMEOUT, 10);
	curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

	$result = curl_exec($ch);
	curl_close($ch);

	$result_decode = json_decode($result, true);
	
	return $result_decode['lists'];
	
}

add_action( 'wp_ajax_mytheme_mailchimp_subscribe', 'mytheme_mailchimp_subscribe' );
add_action( 'wp_ajax_nopriv_mytheme_mailchimp_subscribe', 'mytheme_mailchimp_subscribe' );
function mytheme_mailchimp_subscribe() {

	$out = '';

	$apiKey = $_REQUEST['key'];
	$listId = $_REQUEST['list'];
	
	if($apiKey != '' && $listId != '') {

		$data = array();

		if($_REQUEST['mc_fname'] == ''):
			$data = array('email' => sanitize_email($_REQUEST['email']));
		else:
			$data = array('email' => sanitize_email($_REQUEST['email']), 'merge_fields' => array ( 'FNAME' => $_REQUEST['mc_fname'] ));
		endif;

		if(mytheme_mailchimp_check_member_already_registered($data, $apiKey, $listId)) {
			$out = '<span class="dt-mc-error"><b>'.esc_html__('Error:', 'veda').'</b> '.esc_html__('You have already subscribed with us !', 'veda').'</span>';
		} else {
			$out = mytheme_mailchimp_register_member($data, $apiKey, $listId);
		}

	} else {
		$out = '<span class="dt-mc-error"><b>'.esc_html__('Error:', 'veda').'</b> '.esc_html__('Please make sure valid mailchimp details are provided.', 'veda').'</span>';
	}

	echo ($out);

	die();

}

function mytheme_mailchimp_check_member_already_registered($data, $apiKey, $listId) {
	
	$memberId = md5(strtolower($data['email']));
	$dataCenter = substr($apiKey,strpos($apiKey,'-')+1);
	$url = 'https://' . $dataCenter . '.api.mailchimp.com/3.0/lists/' . $listId . '/members';

	$ch = curl_init($url);

	curl_setopt($ch, CURLOPT_USERPWD, 'user:' . $apiKey);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_TIMEOUT, 10);
	curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

	$result = curl_exec($ch);
	curl_close($ch);

	$result_decode = json_decode($result, true);

	foreach($result_decode['members'] as $key => $value) {
		if($value['email_address'] == $data['email'] && $value['status'] == 'subscribed') {
			return true;
		}
	}
	
	return false;
	
}

function mytheme_mailchimp_register_member($data, $apiKey, $listId) {
	
	$memberId = md5(strtolower($data['email']));
	$dataCenter = substr($apiKey,strpos($apiKey,'-')+1);
	$url = 'https://' . $dataCenter . '.api.mailchimp.com/3.0/lists/' . $listId . '/members/' . $memberId;

	$json = '';

	if(array_key_exists('merge_fields', $data)):
		$json = json_encode( array( 'apikey' => $apiKey, 'email_address' => $data['email'], 'status' => 'pending', 'merge_fields' => array ( 'FNAME' => $data['merge_fields']['FNAME'] ) ));
	else:
		$json = json_encode( array( 'apikey' => $apiKey, 'email_address' => $data['email'], 'status' => 'pending' ));
	endif;

	$ch = curl_init($url);

	curl_setopt($ch, CURLOPT_USERPWD, 'user:' . $apiKey);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json', 'Authorization: Basic '.base64_encode( 'user:'.$apiKey )));
	curl_setopt($ch, CURLOPT_USERAGENT, 'PHP-MCAPI/2.0');
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'PUT');
	curl_setopt($ch, CURLOPT_TIMEOUT, 10);
	curl_setopt($ch, CURLOPT_POST, true);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_POSTFIELDS, $json);

	$result = curl_exec($ch);
	$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
	curl_close($ch);
	
	$result_decode = json_decode($result, true);

	if($httpCode == 200) {
		$out = '<span class="dt-mc-success">'.esc_html__('Success! Please check your inbox or spam folder.', 'veda').'</span>';
	} else {
		$out = '<span class="dt-mc-error"><b>'.$result_decode['title'].':</b> '.$result_decode['detail'].'</span>';
	}
	
	return $out;
	
}

?>