<?php
if ( post_password_required() ) {
	return;
}?>

<div id="comments" class="comments-area">
    <?php if ( have_comments() ) : ?>

	    <h3><?php comments_number(esc_html__('No Comments','veda'), esc_html__('Comment ( 1 )','veda'), esc_html__('Comments ( % )','veda') ); ?></h3>

		<?php the_comments_navigation(); ?>

        <ul class="commentlist">
     		<?php wp_list_comments( array( 'callback' => 'veda_comment_style' ) ); ?>
        </ul>

        <?php the_comments_navigation(); ?>

    <?php endif; ?>

	<?php if ( ! comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) : ?>
        <p class="nocomments"><?php esc_html_e( 'Comments are closed.','veda'); ?></p>
    <?php endif;?>    
	
    <?php
	$comment = "<div class='column dt-sc-one-half first'><textarea id='comment' name='comment' cols='5' rows='3' placeholder='".esc_attr__("Comment",'veda')."' ></textarea></div>";
	
	$fields = array(
		'author' => "<div class='column dt-sc-one-half'><p><input id='author' name='author' type='text' placeholder='".esc_attr__("Name",'veda')."' required /></p>",
		'email'  => "<p> <input id='email' name='email' type='text' placeholder='".esc_attr__("Email",'veda')."' required /> </p></div>",
	);
	
	$privacy_cmdfrm = veda_option('privacy','enable-commentfrm-msg');
	if( isset( $privacy_cmdfrm ) ) {
	
		$content = do_shortcode( veda_option('privacy', 'commentfrm-msg') );
	
		$fields['comment-form-dt-privatepolicy'] = '<p class="comment-form-dt-privatepolicy">
			<input id="comment-form-dt-privatepolicy" name="comment-form-dt-privatepolicy" type="checkbox" value="yes">
			<label for="comment-form-dt-privatepolicy">'.$content.'</label> </p>';
	}
	
	$comments_args = array(
		'title_reply' 		=>	 esc_html__( 'Give a Reply','veda' ),
		'fields'			=>	 $fields,
		'comment_field'		=>   $comment,
		'comment_notes_before'=> '',
		'comment_notes_after'=>	 '',
		'label_submit'		=>	 esc_html__('Comment','veda'));
	
	comment_form($comments_args); ?>

</div><!-- .comments-area -->